/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import com.ibm.wsdl.util.xml.XPathUtils;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSBinding;
import filenet.ws.api.WSBindingFault;
import filenet.ws.api.WSBindingInput;
import filenet.ws.api.WSBindingOutput;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSFault;
import filenet.ws.api.WSOperation;
import filenet.ws.api.WSParameter;
import filenet.ws.api.WSSoapHeader;
import filenet.ws.api.WSTemplateBase;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WSBindingOperation {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    protected static final String m_className = "WSBindingOperation";
    private WSDefinition m_definition = null;
    private WSBinding m_binding = null;
    private BindingOperation m_bindingOperation = null;
    private WSBindingInput m_bindingInput = null;
    private WSBindingOutput m_bindingOutput = null;
    private WSBindingFault[] m_bindingFaults = null;
    private SOAPOperation m_soapOperation = null;
    private HTTPOperation m_httpOperation = null;
    private WSOperation m_operation = null;
    private WSParameter[] m_inParams = null;
    private WSParameter[] m_outParams = null;
    private WSFault[] m_faults = null;
    private String m_operationName = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:03:48  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.37  $";
    }

    public void releaseReferences() {
        block13: {
            try {
                int i;
                this.m_definition = null;
                this.m_binding = null;
                this.m_bindingOperation = null;
                if (this.m_bindingInput != null) {
                    WSBindingInput bindingInput = this.m_bindingInput;
                    this.m_bindingInput = null;
                    bindingInput.releaseReferences();
                    bindingInput = null;
                }
                if (this.m_bindingOutput != null) {
                    WSBindingOutput bindingOutput = this.m_bindingOutput;
                    this.m_bindingOutput = null;
                    bindingOutput.releaseReferences();
                    bindingOutput = null;
                }
                if (this.m_bindingFaults != null) {
                    WSBindingFault[] bindingFaults = this.m_bindingFaults;
                    this.m_bindingFaults = null;
                    for (i = 0; i < bindingFaults.length; ++i) {
                        if (bindingFaults[i] == null) continue;
                        bindingFaults[i].releaseReferences();
                        bindingFaults[i] = null;
                    }
                    bindingFaults = null;
                }
                this.m_soapOperation = null;
                this.m_httpOperation = null;
                if (this.m_operation != null) {
                    WSOperation operation = this.m_operation;
                    this.m_operation = null;
                    operation.releaseReferences();
                    operation = null;
                }
                if (this.m_inParams != null) {
                    WSParameter[] inParams = this.m_inParams;
                    this.m_inParams = null;
                    for (i = 0; i < inParams.length; ++i) {
                        if (inParams[i] == null) continue;
                        inParams[i].releaseReferences();
                        inParams[i] = null;
                    }
                    inParams = null;
                }
                if (this.m_outParams != null) {
                    WSParameter[] outParams = this.m_outParams;
                    this.m_outParams = null;
                    for (i = 0; i < outParams.length; ++i) {
                        if (outParams[i] == null) continue;
                        outParams[i].releaseReferences();
                        outParams[i] = null;
                    }
                    outParams = null;
                }
                if (this.m_faults != null) {
                    WSFault[] faults = this.m_faults;
                    this.m_faults = null;
                    for (i = 0; i < faults.length; ++i) {
                        if (faults[i] == null) continue;
                        faults[i].releaseReferences();
                        faults[i] = null;
                    }
                    faults = null;
                }
                this.m_operationName = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block13;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSBindingOperation(WSDefinition definition, WSBinding binding, BindingOperation bindingOperation) throws IOException {
        this.m_definition = definition;
        this.m_binding = binding;
        this.m_bindingOperation = bindingOperation;
        if (this.m_bindingOperation != null) {
            List l;
            Iterator it;
            this.m_operationName = this.m_bindingOperation.getName();
            Operation op = this.m_bindingOperation.getOperation();
            if (op != null) {
                try {
                    Collection coll;
                    Parameter p = null;
                    Parameters parameters = this.m_definition.m_symTable.getOperationParameters(op, binding.getQName().getNamespaceURI(), binding.getBindingEntry());
                    Vector v = parameters.list;
                    Vector<WSParameter> inParams = new Vector<WSParameter>();
                    Vector<WSParameter> outParams = new Vector<WSParameter>();
                    if (v != null && v.size() > 0) {
                        WSParameter wsParam = null;
                        block7: for (int j = 0; j < v.size(); ++j) {
                            if (v.get(j) == null || !(v.get(j) instanceof Parameter)) continue;
                            p = (Parameter)v.get(j);
                            wsParam = new WSParameter(this.m_definition, this, p);
                            switch (p.getMode()) {
                                case 1: {
                                    inParams.add(wsParam);
                                    continue block7;
                                }
                                case 2: {
                                    outParams.add(wsParam);
                                    continue block7;
                                }
                                case 3: {
                                    inParams.add(wsParam);
                                    outParams.add(wsParam);
                                }
                            }
                        }
                    }
                    if (parameters.returnParam != null) {
                        outParams.add(new WSParameter(this.m_definition, this, parameters.returnParam));
                    }
                    if (inParams != null && inParams.size() > 0) {
                        this.m_inParams = new WSParameter[inParams.size()];
                        inParams.toArray(this.m_inParams);
                        inParams.removeAllElements();
                    }
                    if (outParams != null && outParams.size() > 0) {
                        this.m_outParams = new WSParameter[outParams.size()];
                        outParams.toArray(this.m_outParams);
                        outParams.removeAllElements();
                    }
                    if (parameters.faults != null && (coll = parameters.faults.values()) != null && coll.size() > 0) {
                        this.m_faults = new WSFault[coll.size()];
                        Iterator it2 = coll.iterator();
                        int i = 0;
                        if (it2 != null) {
                            while (it2.hasNext()) {
                                Object obj = it2.next();
                                if (obj == null || !(obj instanceof Fault)) continue;
                                this.m_faults[i++] = new WSFault(this.m_definition, (Fault)obj);
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    System.out.println(ex.getLocalizedMessage());
                }
                QName portType = this.m_binding.getBinding().getPortType().getQName();
                this.m_operation = this.m_definition.getOperation(portType, op.getName(), this.getInputName(), this.getOutputName());
            }
            this.m_bindingInput = new WSBindingInput(this.m_definition, this.m_bindingOperation.getBindingInput());
            this.m_bindingOutput = new WSBindingOutput(this.m_definition, this.m_bindingOperation.getBindingOutput());
            Map map = this.m_bindingOperation.getBindingFaults();
            if (!map.isEmpty()) {
                this.m_bindingFaults = new WSBindingFault[map.size()];
                Collection collection = map.values();
                if (collection != null) {
                    int i = 0;
                    Iterator it3 = collection.iterator();
                    if (it3 != null) {
                        Object obj = null;
                        Object bindingFault = null;
                        while (it3.hasNext()) {
                            obj = it3.next();
                            if (obj == null || !(obj instanceof BindingFault)) continue;
                            this.m_bindingFaults[i++] = new WSBindingFault(this.m_definition, obj);
                        }
                    }
                }
            }
            if ((it = (l = this.m_bindingOperation.getExtensibilityElements()).iterator()) != null) {
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj == null) continue;
                    if (obj instanceof SOAPOperation) {
                        this.m_soapOperation = (SOAPOperation)obj;
                        continue;
                    }
                    if (!(obj instanceof HTTPOperation)) continue;
                    this.m_httpOperation = (HTTPOperation)obj;
                }
            }
        }
    }

    public String getName() {
        if (this.m_bindingOperation != null) {
            return this.m_bindingOperation.getName();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.m_bindingOperation != null) {
            return this.m_bindingOperation.getName();
        }
        return null;
    }

    public BindingOperation getBindingOperation() {
        return this.m_bindingOperation;
    }

    public String toString() {
        return this.m_bindingOperation.toString();
    }

    public String getInParamTemplate() throws Exception {
        String template = null;
        if (this.m_inParams != null && this.m_inParams.length > 0) {
            WSParameter param = null;
            template = new String();
            for (int i = 0; i < this.m_inParams.length; ++i) {
                param = this.m_inParams[i];
                if (param == null || param.getParameter().isInHeader()) continue;
                template = template + param.toXMLTemplateExpression(null) + "\n";
            }
        }
        return template;
    }

    public String getXMLInParamTemplate() throws Exception {
        return this.getXMLInParamTemplate(0);
    }

    public String getXMLInParamTemplate(int bindingStyle) throws Exception {
        String template = null;
        if (this.m_inParams != null && this.m_inParams.length > 0) {
            WSParameter param = null;
            template = new String();
            for (int i = 0; i < this.m_inParams.length; ++i) {
                param = this.m_inParams[i];
                if (param == null) continue;
                template = template + param.toXMLTemplate(bindingStyle, null);
            }
        }
        return template;
    }

    public String getOutParamTemplate() throws Exception {
        String template = null;
        if (this.m_outParams != null && this.m_outParams.length > 0) {
            WSParameter param = null;
            template = new String();
            for (int i = 0; i < this.m_outParams.length; ++i) {
                param = this.m_outParams[i];
                if (param == null) continue;
                template = template + param.toXMLTemplate(null) + "\n";
            }
        }
        return template;
    }

    public WSSoapHeader[] getSoapInHeaders() {
        if (this.m_bindingInput != null) {
            return this.m_bindingInput.getSoapHeaders();
        }
        return null;
    }

    public WSSoapHeader[] getSoapOutHeaders() {
        if (this.m_bindingOutput != null) {
            return this.m_bindingOutput.getSoapHeaders();
        }
        return null;
    }

    public String[] getFaultTemplates() throws Exception {
        if (this.m_faults != null && this.m_faults.length > 0) {
            String[] s = new String[this.m_faults.length];
            WSFault fault = null;
            for (int i = 0; i < this.m_faults.length; ++i) {
                fault = this.m_faults[i];
                if (fault == null) continue;
                s[i] = fault.getFaultTemplate();
            }
            return s;
        }
        return null;
    }

    public boolean isSoapBinding() {
        return this.m_soapOperation != null;
    }

    public String getSoapAction() {
        if (this.m_soapOperation != null) {
            return this.m_soapOperation.getSoapActionURI();
        }
        return null;
    }

    public SOAPOperation getSoapOperation() {
        return this.m_soapOperation;
    }

    public String getSoapStyle() {
        String style = null;
        if (this.m_soapOperation != null) {
            style = this.m_soapOperation.getStyle();
        }
        if (style == null && this.m_binding != null) {
            return this.m_binding.getSoapStyle();
        }
        return style;
    }

    public boolean isSoapRPC() {
        String soapStyle = this.getSoapStyle();
        return soapStyle != null && soapStyle.compareToIgnoreCase("RPC") == 0;
    }

    public String getSoapTransportURI() {
        if (this.m_binding != null) {
            return this.m_binding.getSoapTransportURI();
        }
        return null;
    }

    public String getHTTPBindingVerb() {
        if (this.m_binding != null) {
            return this.m_binding.getHTTPVerb();
        }
        return null;
    }

    public boolean isHTTPBinding() {
        return this.m_httpOperation != null;
    }

    public String getHTTPLocationURI() {
        if (this.m_httpOperation != null) {
            return this.m_httpOperation.getLocationURI();
        }
        return null;
    }

    public WSBindingInput getBindingInput() {
        return this.m_bindingInput;
    }

    public WSBindingOutput getBindingOutput() {
        return this.m_bindingOutput;
    }

    public String getInputName() {
        if (this.m_bindingInput != null && this.m_bindingInput.getBindingInput() != null) {
            return this.m_bindingInput.getBindingInput().getName();
        }
        return null;
    }

    public String getOutputName() {
        if (this.m_bindingOutput != null && this.m_bindingOutput.getBindingOutput() != null) {
            return this.m_bindingOutput.getBindingOutput().getName();
        }
        return null;
    }

    private Document xmlToDocument(String xml) {
        if (xml == null) {
            return null;
        }
        String m_method = "xmlToDocument:";
        try {
            String rootElementName = "tempRoot";
            String s = null;
            if (xml.indexOf("<" + rootElementName + ">") == -1) {
                s = "<" + rootElementName + ">" + WSTemplateBase.replaceAll(xml, "\n", "") + "</" + rootElementName + ">";
            }
            Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(new StringReader(s)), null, null, false, false);
            Document document = XMLHelper.newDocumentViaDOM();
            Element root = document.createElement(rootElementName);
            document.appendChild(root);
            NodeList list = doc.getChildNodes();
            Node node = null;
            node = doc.getFirstChild();
            if (node.getNodeName().compareTo(rootElementName) == 0) {
                list = node.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    if (list.item(i) == null || list.item(i).getNodeType() != 1) continue;
                    Element elt = this.createElement(document, list.item(i));
                    root.appendChild(elt);
                }
            } else {
                Element elt = this.createElement(document, node);
                root.appendChild(elt);
            }
            return document;
        }
        catch (Throwable t) {
            logger.throwing(m_className, m_method, t);
            return null;
        }
    }

    private Element createElement(Document doc, Node node) {
        NodeList list;
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        Element element = doc.createElement(node.getNodeName());
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            Node attribute = null;
            for (int j = 0; j < attributes.getLength(); ++j) {
                attribute = attributes.item(j);
                element.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        if ((list = node.getChildNodes()) != null && list.getLength() > 0) {
            Node nd = null;
            block6: for (int i = 0; i < list.getLength(); ++i) {
                nd = list.item(i);
                short nodeType = nd.getNodeType();
                switch (nodeType) {
                    case 2: 
                    case 8: {
                        continue block6;
                    }
                    case 3: {
                        element.appendChild(doc.createTextNode(nd.getNodeValue()));
                        continue block6;
                    }
                    case 1: {
                        element.appendChild(this.createElement(doc, nd));
                    }
                }
            }
        }
        return element;
    }

    public String addedBindingInfoToInParam(String inParamXML) throws Exception {
        if (inParamXML == null || inParamXML.length() == 0) {
            return null;
        }
        String results = inParamXML;
        Document paramDoc = this.xmlToDocument(inParamXML);
        Document templateDoc = this.xmlToDocument(this.getXMLInParamTemplate(2));
        Element[] paramNodes = this.getElementNodes(paramDoc);
        Element[] templateNodes = this.getElementNodes(templateDoc);
        if (paramNodes != null && paramNodes.length > 0 && templateNodes != null && templateNodes.length > 0) {
            int i;
            Element pElement = null;
            Object pName = null;
            String pXPath = null;
            Element tElement = null;
            Object tName = null;
            String tXPath = null;
            String s = null;
            int idx = -1;
            int start = 0;
            int len = 0;
            block0: for (i = 0; i < paramNodes.length; ++i) {
                pElement = paramNodes[i];
                if (pElement == null) continue;
                s = XPathUtils.getXPathExprFromNode((Node)pElement);
                start = 0;
                if (s == null) continue;
                pXPath = new String();
                len = s.length();
                while ((idx = s.indexOf("[", start)) != -1) {
                    pXPath = pXPath + s.substring(start, idx);
                    start = s.indexOf("]", idx) + 1;
                    if (start != len) continue;
                }
                pXPath = pXPath + s.substring(start, len);
                boolean bFound = false;
                for (int j = 0; j < templateNodes.length; ++j) {
                    NamedNodeMap map;
                    tElement = templateNodes[j];
                    if (tElement == null || (tXPath = XPathUtils.getXPathExprFromNode((Node)tElement)) == null || pXPath.compareTo(tXPath) != 0) continue;
                    if (this.isSoapRPC() && (map = tElement.getAttributes()) != null && map.getLength() > 0) {
                        Node attributeNode = null;
                        for (int k = 0; k < map.getLength(); ++k) {
                            attributeNode = map.item(k);
                            pElement.setAttribute(attributeNode.getNodeName(), attributeNode.getNodeValue());
                        }
                    }
                    bFound = true;
                    continue block0;
                }
            }
            for (i = 0; i < paramNodes.length; ++i) {
                String arrayType;
                if (paramNodes[i] == null || (arrayType = paramNodes[i].getAttribute("soapenc:arrayType")) == null || arrayType.length() <= 0) continue;
                int index = arrayType.indexOf("[]");
                int count = 0;
                for (int j = 0; j < paramNodes.length; ++j) {
                    if (paramNodes[j] == null || paramNodes[j].getParentNode() != paramNodes[i]) continue;
                    ++count;
                }
                arrayType = arrayType.substring(0, index);
                arrayType = arrayType + "[" + count + "]";
                paramNodes[i].setAttribute("soapenc:arrayType", arrayType);
            }
            results = WSTemplateBase.elementToString(paramDoc);
            results = results.trim();
        }
        return results;
    }

    private Element[] getElementNodes(Document doc) {
        if (doc != null) {
            Vector v = new Vector();
            Vector childElements = null;
            NodeList list = doc.getChildNodes();
            Node node = null;
            for (int i = 0; i < list.getLength(); ++i) {
                node = list.item(i);
                if (!(node instanceof Element) || (childElements = this.getElementNodes((Element)node)) == null || childElements.size() <= 0) continue;
                v.addAll(childElements);
            }
            if (v != null && v.size() > 0) {
                Element[] nodes = new Element[v.size()];
                v.toArray(nodes);
                v.removeAllElements();
                return nodes;
            }
        }
        return null;
    }

    private Vector getElementNodes(Element element) {
        if (element == null) {
            return null;
        }
        Vector<Element> v = new Vector<Element>();
        if (element != null) {
            v.add(element);
            Vector childElements = null;
            NodeList list = element.getChildNodes();
            Node node = null;
            for (int i = 0; i < list.getLength(); ++i) {
                node = list.item(i);
                if (!(node instanceof Element) || (childElements = this.getElementNodes((Element)node)) == null || childElements.size() <= 0) continue;
                v.addAll(childElements);
            }
        }
        return v;
    }
}

